	function Taug = LATTICE_RICHARDS_TAUG(alfa_odd, alfa_even, wT)
 
	% 	Computes the group delay for the even and odd  
	%	branches in a lattice filter with cascaded first- and
	%	second-order Richards' series sections and symmetric adaptors. 
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2014-08-06
	% 	Modified by: 	
	% 	Version: 	1
	% 	Copyright:		by authors - not released for commercial use		
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	% Odd branch
	P_odd(1) = alfa_odd(1);
	for k = 2:2:length(alfa_odd)-1
		R = roots([1 -alfa_odd(k+1)*(1-alfa_odd(k)) -alfa_odd(k)]);
		P_odd = [P_odd; R];
	end
	Taug_odd = PZ_2_TG_Z(1, 1./P_odd, P_odd, wT);
	
	% Even branch
	P_even = [];
	for k = 1:2:length(alfa_even)
		R = roots([1 -alfa_even(k+1)*(1-alfa_even(k)) -alfa_even(k)]);
		P_even = [P_even; R];
	end
	Taug_even = PZ_2_TG_Z(1, 1./P_even, P_even, wT);
	Taug = (Taug_odd + Taug_even)/2;
